#tag DesktopWindow
Begin DesktopWindow Window1
   Backdrop        =   0
   BackgroundColor =   &cFFFFFF
   Composite       =   False
   DefaultLocation =   2
   FullScreen      =   False
   HasBackgroundColor=   False
   HasCloseButton  =   True
   HasFullScreenButton=   False
   HasMaximizeButton=   True
   HasMinimizeButton=   True
   HasTitleBar     =   True
   Height          =   540
   ImplicitInstance=   True
   MacProcID       =   0
   MaximumHeight   =   32000
   MaximumWidth    =   32000
   MenuBar         =   1681170431
   MenuBarVisible  =   False
   MinimumHeight   =   64
   MinimumWidth    =   64
   Resizeable      =   True
   Title           =   "Untitled"
   Type            =   0
   Visible         =   True
   Width           =   600
   Begin DesktopTextArea TextArea1
      AllowAutoDeactivate=   True
      AllowFocusRing  =   True
      AllowSpellChecking=   True
      AllowStyledText =   True
      AllowTabs       =   False
      BackgroundColor =   &cFFFFFF
      Bold            =   False
      Enabled         =   True
      FontName        =   "System"
      FontSize        =   0.0
      FontUnit        =   0
      Format          =   ""
      HasBorder       =   True
      HasHorizontalScrollbar=   False
      HasVerticalScrollbar=   True
      Height          =   236
      HideSelection   =   True
      Index           =   -2147483648
      Italic          =   False
      Left            =   20
      LineHeight      =   0.0
      LineSpacing     =   1.0
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      MaximumCharactersAllowed=   0
      Multiline       =   True
      ReadOnly        =   False
      Scope           =   0
      TabIndex        =   0
      TabPanelIndex   =   0
      TabStop         =   True
      Text            =   ""
      TextAlignment   =   0
      TextColor       =   &c000000
      Tooltip         =   ""
      Top             =   20
      Transparent     =   False
      Underline       =   False
      UnicodeMode     =   1
      ValidationMask  =   ""
      Visible         =   True
      Width           =   568
   End
   Begin DesktopButton Button1
      AllowAutoDeactivate=   True
      Bold            =   False
      Cancel          =   False
      Caption         =   "Generate token"
      Default         =   False
      Enabled         =   True
      FontName        =   "System"
      FontSize        =   0.0
      FontUnit        =   0
      Height          =   24
      Index           =   -2147483648
      Italic          =   False
      Left            =   20
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      MacButtonStyle  =   0
      Scope           =   0
      TabIndex        =   1
      TabPanelIndex   =   0
      TabStop         =   True
      Tooltip         =   ""
      Top             =   268
      Transparent     =   False
      Underline       =   False
      Visible         =   True
      Width           =   217
   End
   Begin DesktopButton Button2
      AllowAutoDeactivate=   True
      Bold            =   False
      Cancel          =   False
      Caption         =   "Decode token"
      Default         =   False
      Enabled         =   True
      FontName        =   "System"
      FontSize        =   0.0
      FontUnit        =   0
      Height          =   24
      Index           =   -2147483648
      Italic          =   False
      Left            =   20
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      MacButtonStyle  =   0
      Scope           =   0
      TabIndex        =   2
      TabPanelIndex   =   0
      TabStop         =   True
      Tooltip         =   ""
      Top             =   343
      Transparent     =   False
      Underline       =   False
      Visible         =   True
      Width           =   217
   End
   Begin DesktopButton Button3
      AllowAutoDeactivate=   True
      Bold            =   False
      Cancel          =   False
      Caption         =   "Generate token with custom claims"
      Default         =   False
      Enabled         =   True
      FontName        =   "System"
      FontSize        =   0.0
      FontUnit        =   0
      Height          =   24
      Index           =   -2147483648
      Italic          =   False
      Left            =   20
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      MacButtonStyle  =   0
      Scope           =   0
      TabIndex        =   3
      TabPanelIndex   =   0
      TabStop         =   True
      Tooltip         =   ""
      Top             =   305
      Transparent     =   False
      Underline       =   False
      Visible         =   True
      Width           =   217
   End
   Begin DesktopButton Button4
      AllowAutoDeactivate=   True
      Bold            =   False
      Cancel          =   False
      Caption         =   "Decode token and list claims"
      Default         =   False
      Enabled         =   True
      FontName        =   "System"
      FontSize        =   0.0
      FontUnit        =   0
      Height          =   24
      Index           =   -2147483648
      Italic          =   False
      Left            =   20
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      MacButtonStyle  =   0
      Scope           =   0
      TabIndex        =   4
      TabPanelIndex   =   0
      TabStop         =   True
      Tooltip         =   ""
      Top             =   382
      Transparent     =   False
      Underline       =   False
      Visible         =   True
      Width           =   217
   End
   Begin DesktopListBox ListBox1
      AllowAutoDeactivate=   True
      AllowAutoHideScrollbars=   True
      AllowExpandableRows=   False
      AllowFocusRing  =   True
      AllowResizableColumns=   False
      AllowRowDragging=   False
      AllowRowReordering=   False
      Bold            =   False
      ColumnCount     =   2
      ColumnWidths    =   ""
      DefaultRowHeight=   -1
      DropIndicatorVisible=   False
      Enabled         =   True
      FontName        =   "System"
      FontSize        =   0.0
      FontUnit        =   0
      GridLineStyle   =   0
      HasBorder       =   True
      HasHeader       =   True
      HasHorizontalScrollbar=   False
      HasVerticalScrollbar=   True
      HeadingIndex    =   -1
      Height          =   252
      Index           =   -2147483648
      InitialValue    =   "Claim	Value"
      Italic          =   False
      Left            =   288
      LockBottom      =   False
      LockedInPosition=   False
      LockLeft        =   True
      LockRight       =   False
      LockTop         =   True
      RequiresSelection=   False
      RowSelectionType=   0
      Scope           =   0
      TabIndex        =   5
      TabPanelIndex   =   0
      TabStop         =   True
      Tooltip         =   ""
      Top             =   268
      Transparent     =   False
      Underline       =   False
      Visible         =   True
      Width           =   300
      _ScrollOffset   =   0
      _ScrollWidth    =   -1
   End
End
#tag EndDesktopWindow

#tag WindowCode
#tag EndWindowCode

#tag Events Button1
	#tag Event
		Sub Pressed()
		  //Test and validate at: https://www.jwt.io/
		  
		  #Pragma BreakOnExceptions False
		  
		  try
		    var params as new EinhugurJWT.EncodingParameters()
		    
		    params.Algorithm = EinhugurJWT.Algorithm.HS512
		    
		    params.Subject = "Björn Eiríksson"
		    params.Issuer = "Einhugur"
		    params.Audience = "Administrator"
		    
		    params.IssuedAt = EinhugurJWT.TimeSinceUnixEpoc()
		    params.Expiration = params.IssuedAt + 600 // Set to expire after 10 minutes (600 seconds).
		    
		    params.SecretKey = "Some SupER s3kret HMAC keY"
		    
		    TextArea1.Text = EinhugurJWT.Encode(params)
		    
		  catch ex as EinhugurJWT.JWTException
		    MessageBox(ex.Message)
		  end try
		  
		  #Pragma BreakOnExceptions Default
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events Button2
	#tag Event
		Sub Pressed()
		  #Pragma BreakOnExceptions False
		  
		  try
		    var params as new EinhugurJWT.DecodingParameters()
		    
		    params.Algorithm = EinhugurJWT.Algorithm.HS512
		    params.JWT =TextArea1.Text
		    
		    params.VerificationKey = "Some SupER s3kret HMAC keY"
		    
		    params.ValidateSubject = "Björn Eiríksson"
		    params.ValidateIssuer = "Einhugur"
		    
		    params.ValidateExpiration = true
		    params.ExpirationToleranceSeconds = 60
		    
		    params.ValidateIssuedAt = true
		    params.IssuedAtToleranceSeconds = 60
		    
		    var result as EinhugurJWT.JWTResult = EinhugurJWT.Decode(params, false)
		    
		    if result.ValidationResult = result.ResultValid then
		      MessageBox "Token is valid."
		    else
		      // The result is bitmask and we can have multiple faults which is why we will not be using elseif here.
		      if (result.ValidationResult and result.ResultTokenIsExpired) = result.ResultTokenIsExpired then
		        MessageBox "Token has expired."
		      end if
		      
		      if (result.ValidationResult and result.ResultTokenIsNotYetValid) = result.ResultTokenIsNotYetValid then
		        MessageBox "The token is not yet valid."
		      end if
		      
		      if (result.ValidationResult and result.ResultTokenNotIssuedYet) = result.ResultTokenNotIssuedYet then
		        MessageBox "The token has not been issued yet, are you from the future?"
		      end if
		      
		      if (result.ValidationResult and result.ResultAudienceClaimInvalid) = result.ResultAudienceClaimInvalid then
		        MessageBox "The audience claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultIdClaimInvalid) = result.ResultIdClaimInvalid then
		        MessageBox "The JWT ID claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultIssuerClaimInvalid) = result.ResultIssuerClaimInvalid then
		        MessageBox "The issuer claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultSignatureVerificationFailure) = result.ResultSignatureVerificationFailure then
		        MessageBox "The token was potentially tampered with: its signature couldn't be verified."
		      end if
		      
		      if (result.ValidationResult and result.ResultSubjectClaimInvalid) = result.ResultSubjectClaimInvalid then
		        MessageBox "The subject claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultTypeClaimFailure) = result.ResultTypeClaimFailure then
		        MessageBox "The token's ""typ"" claim validation failed."
		      end if
		    end if
		    
		  catch ex as EinhugurJWT.JWTException
		    MessageBox(ex.Message)
		  end try
		  
		  #Pragma BreakOnExceptions Default
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events Button3
	#tag Event
		Sub Pressed()
		  #Pragma BreakOnExceptions False
		  
		  //Test and validate at: https://www.jwt.io/
		  
		  try
		    var params as new EinhugurJWT.EncodingParameters()
		    
		    params.Algorithm = EinhugurJWT.Algorithm.HS512
		    
		    params.Subject = "Björn Eiríksson"
		    params.Issuer = "Einhugur"
		    params.Audience = "Administrator"
		    
		    params.IssuedAt = EinhugurJWT.TimeSinceUnixEpoc()
		    params.Expiration = params.IssuedAt + 600 // Set to expire after 10 minutes (600 seconds).
		    
		    params.SecretKey = "Some SupER s3kret HMAC keY"
		    
		    // Add some custom claims
		    params.AddPayloadClaim("Test", "Someclaim", EinhugurJWT.ClaimType.StringClaim)
		    params.AddPayloadClaim("Test1", "Someclaim", EinhugurJWT.ClaimType.StringClaim)
		    params.AddPayloadClaim("Test2", "23", EinhugurJWT.ClaimType.IntegerClaim)
		    params.AddPayloadClaim("Test3", "23.0", EinhugurJWT.ClaimType.NumberClaim)
		    params.AddPayloadClaim("Test4", "null", EinhugurJWT.ClaimType.NullClaim)
		    params.AddPayloadClaim("Test5", "true", EinhugurJWT.ClaimType.BooleanClaim)
		    params.AddPayloadClaim("Test6", "[""Ford"", ""BMW"", ""Fiat""]", EinhugurJWT.ClaimType.ArrayClaim)
		    params.AddPayloadClaim("Test7", "{""name"":""John"", ""age"":30, ""city"":""New York""}", EinhugurJWT.ClaimType.ObjectClaim)
		    
		    params.AddHeaderClaim("HeaderTest", "Someheaderclaim", EinhugurJWT.ClaimType.StringClaim)
		    
		    TextArea1.Text = EinhugurJWT.Encode(params)
		    
		  catch ex as EinhugurJWT.JWTException
		    MessageBox(ex.Message)
		  end try
		  
		  #Pragma BreakOnExceptions Default
		End Sub
	#tag EndEvent
#tag EndEvents
#tag Events Button4
	#tag Event
		Sub Pressed()
		  #Pragma BreakOnExceptions False
		  
		  try
		    var params as new EinhugurJWT.DecodingParameters()
		    
		    params.Algorithm = EinhugurJWT.Algorithm.HS512
		    params.JWT =TextArea1.Text
		    
		    params.VerificationKey = "Some SupER s3kret HMAC keY"
		    
		    params.ValidateSubject = "Björn Eiríksson"
		    params.ValidateIssuer = "Einhugur"
		    
		    params.ValidateExpiration = true
		    params.ExpirationToleranceSeconds = 60
		    
		    params.ValidateIssuedAt = true
		    params.IssuedAtToleranceSeconds = 60
		    
		    var result as EinhugurJWT.JWTResult = EinhugurJWT.Decode(params, true)
		    
		    if result.ValidationResult = result.ResultValid then
		      MessageBox "Token is valid."
		      
		      ListBox1.RemoveAllRows()
		      for each claim as EinhugurJWT.Claim in result.Claims
		        ListBox1.AddRow(array(claim.Key, claim.Value))
		      next
		    else
		      // The result is bitmask and we can have multiple faults which is why we will not be using elseif here.
		      if (result.ValidationResult and result.ResultTokenIsExpired) = result.ResultTokenIsExpired then
		        MessageBox "Token has expired."
		      end if
		      
		      if (result.ValidationResult and result.ResultTokenIsNotYetValid) = result.ResultTokenIsNotYetValid then
		        MessageBox "The token is not yet valid."
		      end if
		      
		      if (result.ValidationResult and result.ResultTokenNotIssuedYet) = result.ResultTokenNotIssuedYet then
		        MessageBox "The token has not been issued yet, are you from the future?"
		      end if
		      
		      if (result.ValidationResult and result.ResultAudienceClaimInvalid) = result.ResultAudienceClaimInvalid then
		        MessageBox "The audience claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultIdClaimInvalid) = result.ResultIdClaimInvalid then
		        MessageBox "The JWT ID claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultIssuerClaimInvalid) = result.ResultIssuerClaimInvalid then
		        MessageBox "The issuer claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultSignatureVerificationFailure) = result.ResultSignatureVerificationFailure then
		        MessageBox "The token was potentially tampered with: its signature couldn't be verified."
		      end if
		      
		      if (result.ValidationResult and result.ResultSubjectClaimInvalid) = result.ResultSubjectClaimInvalid then
		        MessageBox "The subject claim is invalid."
		      end if
		      
		      if (result.ValidationResult and result.ResultTypeClaimFailure) = result.ResultTypeClaimFailure then
		        MessageBox "The token's ""typ"" claim validation failed."
		      end if
		    end if
		    
		  catch ex as EinhugurJWT.JWTException
		    MessageBox(ex.Message)
		  end try
		  
		  #Pragma BreakOnExceptions Default
		End Sub
	#tag EndEvent
#tag EndEvents
#tag ViewBehavior
	#tag ViewProperty
		Name="Name"
		Visible=true
		Group="ID"
		InitialValue=""
		Type="String"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Interfaces"
		Visible=true
		Group="ID"
		InitialValue=""
		Type="String"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Super"
		Visible=true
		Group="ID"
		InitialValue=""
		Type="String"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Width"
		Visible=true
		Group="Size"
		InitialValue="600"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Height"
		Visible=true
		Group="Size"
		InitialValue="400"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MinimumWidth"
		Visible=true
		Group="Size"
		InitialValue="64"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MinimumHeight"
		Visible=true
		Group="Size"
		InitialValue="64"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MaximumWidth"
		Visible=true
		Group="Size"
		InitialValue="32000"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MaximumHeight"
		Visible=true
		Group="Size"
		InitialValue="32000"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Type"
		Visible=true
		Group="Frame"
		InitialValue="0"
		Type="Types"
		EditorType="Enum"
		#tag EnumValues
			"0 - Document"
			"1 - Movable Modal"
			"2 - Modal Dialog"
			"3 - Floating Window"
			"4 - Plain Box"
			"5 - Shadowed Box"
			"6 - Rounded Window"
			"7 - Global Floating Window"
			"8 - Sheet Window"
			"9 - Modeless Dialog"
		#tag EndEnumValues
	#tag EndViewProperty
	#tag ViewProperty
		Name="Title"
		Visible=true
		Group="Frame"
		InitialValue="Untitled"
		Type="String"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="HasCloseButton"
		Visible=true
		Group="Frame"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="HasMaximizeButton"
		Visible=true
		Group="Frame"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="HasMinimizeButton"
		Visible=true
		Group="Frame"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="HasFullScreenButton"
		Visible=true
		Group="Frame"
		InitialValue="False"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="HasTitleBar"
		Visible=true
		Group="Frame"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Resizeable"
		Visible=true
		Group="Frame"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="Composite"
		Visible=false
		Group="OS X (Carbon)"
		InitialValue="False"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MacProcID"
		Visible=false
		Group="OS X (Carbon)"
		InitialValue="0"
		Type="Integer"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="FullScreen"
		Visible=true
		Group="Behavior"
		InitialValue="False"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="DefaultLocation"
		Visible=true
		Group="Behavior"
		InitialValue="2"
		Type="Locations"
		EditorType="Enum"
		#tag EnumValues
			"0 - Default"
			"1 - Parent Window"
			"2 - Main Screen"
			"3 - Parent Window Screen"
			"4 - Stagger"
		#tag EndEnumValues
	#tag EndViewProperty
	#tag ViewProperty
		Name="Visible"
		Visible=true
		Group="Behavior"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="ImplicitInstance"
		Visible=true
		Group="Window Behavior"
		InitialValue="True"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="HasBackgroundColor"
		Visible=true
		Group="Background"
		InitialValue="False"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="BackgroundColor"
		Visible=true
		Group="Background"
		InitialValue="&cFFFFFF"
		Type="ColorGroup"
		EditorType="ColorGroup"
	#tag EndViewProperty
	#tag ViewProperty
		Name="Backdrop"
		Visible=true
		Group="Background"
		InitialValue=""
		Type="Picture"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MenuBar"
		Visible=true
		Group="Menus"
		InitialValue=""
		Type="DesktopMenuBar"
		EditorType=""
	#tag EndViewProperty
	#tag ViewProperty
		Name="MenuBarVisible"
		Visible=true
		Group="Deprecated"
		InitialValue="False"
		Type="Boolean"
		EditorType=""
	#tag EndViewProperty
#tag EndViewBehavior
